#!/usr/bin/python

#copy common files into doc dir!!
import os, time, _winreg, shutil, sys

starttime = time.strftime('%X %x %Z')

scriptdir = os.path.dirname(os.path.abspath(sys.argv[0]))

language = "unknown"

#Terminate with help message if no arguments.
if len(sys.argv) == 1:
    print "Please supply the path to your Delphi project and an optional content directory as arguments.\n"
    print "For more information on usage, please see readme.html in this directory.\n"
    sys.exit(0)

#Take command line parameter for base directory and content directory    
basedir = os.path.abspath(sys.argv[1])
if len(sys.argv) == 3:
 contentdir = sys.argv[2]
else:
    contentdir = os.path.join(basedir, "doc", "content")

#Create doc directory tree in base directory if it doesn't exist.
if not os.path.exists(os.path.join(basedir, "doc")):
    os.makedirs(os.path.join(basedir, "doc"))

docdir = os.path.join(basedir, "doc");

# determines whether a given XML file looks like compiler output
def iscompileroutput(filepath):
    xmlfile = file(filepath)
    line1 = xmlfile.readline()
    line2 = xmlfile.readline()
    if line1.find('<?xml version="1.0" encoding="utf-8"?>') != -1 and\
       line2.find('<namespace name="') == 0:
        return True
    else:
        return False
    
#Recursively copy all XML files from tree starting at base to xmldoc/APInorm
#Filter out the contents of the doc dir.
def copyXML(arg, directory, files):
    global language
    for filename in files:
        # print "checking", directory, filename,"..."
	if filename == "templates" or filename == "content" and directory.endswith ("\\doc"):
		del files[files.index(filename)]
		print "skipping files in", os.path.join(directory,filename), "because they appear to be previous XMLDoc tool output."
        elif filename.endswith(".xml"):
            if iscompileroutput(os.path.join(directory,filename)):
                language = "Delphi"
            shutil.copyfile(os.path.join(directory, filename), os.path.join(scriptdir, "xmldoc", "APInorm", "compileroutput", filename))


#copies any .DLL or .EXE files into the xmldoc/APInorm/reflectxml folder for the C# language
def reflectDLLorEXE (arg, directory, filenames):
    for filename in filenames:
        if filename.endswith(".exe") or filename.endswith(".dll"):
#            if os.path.isfile(os.path.join(basedir, filename[:-4] + ".xml")):
             command = "reflectxml.exe \"" + os.path.join(directory, filename) + "\""
             os.system(command)




if os.path.exists(os.path.join(scriptdir, "xmldoc", "APInorm",
                                   "compileroutput")):
    shutil.rmtree(os.path.join(scriptdir, "xmldoc", "APInorm",
                                   "compileroutput"))
os.makedirs(os.path.join(scriptdir, "xmldoc", "APInorm",
                                   "compileroutput"))
            
os.path.walk(basedir, copyXML, "")

if language == "unknown":
    # deletes any xml files in the reflectxml folder in case of duplicate names
    # this way the files are not appended by the reflect xml tool
    reflectdir = os.path.join(scriptdir, "xmldoc", "APInorm", "reflectxml")
    if not os.path.exists(reflectdir):
        os.makedirs(reflectdir)
    os.chdir(reflectdir)

    for filename in os.listdir(reflectdir):
        if filename.endswith(".xml"):
            os.remove(os.path.join(reflectdir, filename))

    os.path.walk(basedir, reflectDLLorEXE, None)
    language = "CSharp"
    

#run norm
normdir = os.path.join(scriptdir, "xmldoc", "APInorm")
os.chdir( normdir )
command = "APInorm.py " + language
os.system(command)

#Delete existing devnotes and template dirs. Copy devnotes and template files to respective directories.  Remove backup from normdir after copy has succeeded.
if os.path.exists(os.path.join(docdir, "content")):
    shutil.rmtree(os.path.join(docdir, "content"))
if os.path.exists(os.path.join(docdir, "templates")):
    shutil.rmtree(os.path.join(docdir, "templates"))
if os.path.exists(os.path.join(normdir, "content")):
    shutil.copytree(os.path.join(normdir, "content"), os.path.join(docdir, "content"))
if os.path.exists(os.path.join(normdir, "templates")):
    shutil.copytree(os.path.join(normdir, "templates"), os.path.join(docdir, "templates"))
if os.path.exists(os.path.join(normdir, "content")):
    shutil.rmtree(os.path.join(normdir, "content"))
if os.path.exists(os.path.join(normdir, "templates")):
    shutil.rmtree(os.path.join(normdir, "templates"))


#copy result files and content files to xmldoc/APImerge
mergedir = os.path.join(scriptdir, "xmldoc", "APImerge")
if os.path.exists(os.path.join(mergedir, "chopdata")):
    shutil.rmtree(os.path.join(mergedir, "chopdata"))
if os.path.exists(contentdir):
    shutil.copytree(contentdir, os.path.join(mergedir, "chopdata"))
if os.path.exists(os.path.join(mergedir, "normalized")):
    shutil.rmtree(os.path.join(mergedir, "normalized"))
shutil.copytree(os.path.join(normdir, "normalized"), os.path.join(mergedir, "normalized"))

#run merge.
os.chdir( mergedir )
command = "APImerge.py " + language
os.system(command)

#copy final output to the "final" directory.
#Check to see if final dir exists, and then create it.
if os.path.exists(os.path.join(docdir, "final")):
    shutil.rmtree(os.path.join(docdir, "final"))
shutil.copytree(os.path.join(mergedir, "html"), os.path.join(docdir, "final"))
if os.path.exists(os.path.join(docdir, "common")):
    shutil.rmtree(os.path.join(docdir, "common"))
shutil.copytree(os.path.join(mergedir, "common"), os.path.join(docdir, "common"))

os.remove("C:\\xmldoctemp.txt")
print "began at "+starttime+"\ncompleted at "+time.strftime('%X %x %Z')


